<?php

//Requiring the flow api client
require_once "./lib/FlowApi.class.php";
require_once "./lib/Config.class.php";
require_once './lib/flowhelper.php';
use FlowApi\Webpay\FlowApi;
use FlowApi\Webpay\Config;

include("../../../includes/functions.php");
include("../../../includes/gatewayfunctions.php");
include("../../../includes/invoicefunctions.php");

if (file_exists('../../../dbconnect.php')) {
	include '../../../dbconnect.php';
} else if (file_exists('../../../init.php')) {
	include '../../../init.php';
}

try{
    
    
    global $CONFIG;
    logActivity('Entering the return file...', 0);
    $flowToken = filter_input(INPUT_POST, 'token', FILTER_SANITIZE_STRING);
    $flowConfig = getGatewayVariables(Config::GATEWAY_NAME);
    $service = 'payment/getStatus';
    $method = 'GET';
    $mode = $flowConfig['mode'];
    $paymentMode = Config::PAYMENT_MODE;
    $endpoint = Config::ENDPOINTS[$mode];
    $flowParams = array(
        'token' =>  $flowToken,
    );

    $flowApi = new FlowApi;
    $flowApi->setKeys($flowConfig['apiKey'], $flowConfig['secretKey']);
    $flowOrderData = $flowApi->send($service, $flowParams, $endpoint, $method);
    
    $flowOrderId = $flowOrderData["flowOrder"];
	$amountPaidInFlow = $flowOrderData['paymentData']['amount'];
    $fees = $flowOrderData['paymentData']['fee'];
    
    $invoiceId = $flowOrderData['commerceOrder'];

    $command = 'GetInvoice';
    $postData = array(
        'invoiceid' =>  $invoiceId
    );

    $invoice = localAPI($command, $postData, '');

    $invoiceStatus = strtolower($invoice['status']);

    if(FlowHelper::userCanceledPayment($flowOrderData)){
        logActivity('User canceled payment. Redirecting to checkout...', 0);
        $checkoutUrl = $CONFIG['SystemURL'].'/viewinvoice.php?id='.$invoiceId;
        header('Location: '.$checkoutUrl);
        exit();
    }

    /*if(FlowHelper::isTesting($flowOrderData, $flowConfig)){
		logActivity('Setting up the simulation...', 0);
		FlowHelper::setUpProductionEnvSimulation($flowOrderData);
    }*/

    $statusInFlow = $flowOrderData['status'];

    if(FlowHelper::isPendingInFlow($statusInFlow)){

        //If user has any custom url configured, we redirect them there.
        if(!empty($flowConfig['customReturnUrl'])){
            header('Location: '.$flowConfig['customReturnUrl']);
            exit();
        }

        $couponGeneratedUrl = $CONFIG['SystemURL'].'/modules/gateways/flowwp/flowwp_coupon.php';
        header('Location: '.$couponGeneratedUrl);
        exit();
    }
    //If the order is paid in flow but appears unpaid in the store, we pay it right here.
    elseif(FlowHelper::isPaidInFlow($statusInFlow)){

        if($invoiceStatus == 'unpaid'){

            addInvoicePayment(
                $invoiceId,
                $flowOrderId,
                $amountPaidInFlow,
                $fees,
                Config::GATEWAY_NAME
            );
        }
    }

    //Then we redirect to the standard end url, where the order will be checked and the user will be redirected
    //to the appropiate page by the system.
    $resultUrl = $CONFIG['SystemURL'].'/viewinvoice.php?id='.$invoiceId;
    header('Location: '.$resultUrl);
    exit();


}catch(\Exception $e){

    error_log($e->getMessage());
    logActivity('The has been an unexpected error. Code: '.$e->getCode(). ' Message:'.$e->getMessage());
    $errorUrl = $CONFIG['SystemURL'].'/modules/gateways/flowwp/flowwp_error.php';
    header('Location: '.$errorUrl);
    exit();
}
