<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package WordPress
 * @since New Host 1.0
 */

get_header(); ?>

<div class="single_page">

	<div id="primary" class="content-area">
	
		<div id="content" class="site-content" role="main">

			<?php while ( have_posts() ) : the_post(); ?>

		    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
						
				<div class="entry-thumbnail">
							
				    <?php the_post_thumbnail(); ?>
						    
				</div>
							
				<?php endif; ?>

				<h1 class="entry-title"><?php the_title(); ?></h1>

				<div class="entry-content">
						        
					<?php the_content(); ?>
						        
					<?php wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'twentythirteen' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?>
	
				</div><!-- .entry-content -->

			</article><!-- #post -->

			<?php endwhile; ?>

		</div><!-- #content -->
				
	</div><!-- #primary -->
	
	</div><!-- #Footer -->
	
</div><!-- #span9 -->
			
<?php get_footer(); ?>