<?php 

// Custom Heading
add_shortcode('heading','heading_func');



function heading_func($atts, $content = null){
	extract(shortcode_atts(array(
		'text'		=>	'',
		'tag'		=> 	'h1',
		'size'		=>	'',
		'color'		=>	'',
		'align'		=>	'left',
		'class'		=>	'',
		'desc'      =>	'',
	), $atts));

	$html = '';

	$size1 = (!empty($size) ? 'font-size: '.$size.';' : '');
	$color1 = (!empty($color) ? 'color: '.$color.';' : '');
	$align1 = (!empty($align) ? 'text-align: '.$align.';' : '');
	$class1 = (!empty($class) ? $class.'' : '');
	$desc1 = (!empty($desc) ? '<i>'. $desc .'</i>' : '');

	$html .= '<div class="'.$class1.'" >'; 
	$html .= '<'.$tag.' style="' . $size1 . $align1 . $color1 .'">'. $text . $desc1 .'</'.$tag.'>';	
	$html .= '</div>';

	return $html;
}

// Services
add_shortcode('service', 'service_func');
function service_func($atts, $content = null){
	extract(shortcode_atts(array(
		'icon' => '',
		'title' 	=> '',
		'desc' 	=> '',
		'link'  => '',
		'css'  => '',
	), $atts));

	$url = vc_build_link( $link );
	$img = wp_get_attachment_image_src($icon,'full');
    $img = $img[0];

	ob_start(); ?>

	<div class="features_section" <?php echo vc_shortcode_custom_css_class( $css ); ?>>
		<div class="sections">
	    	<div class="left"><img src="<?php echo esc_url($img); ?>" alt="" /></div>
			<div class="right">
				<?php if ( strlen( $link ) > 0 && strlen( $url['url'] ) > 0 ) {
					echo '<h4><a href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'.esc_attr($title).'</a></h4>';
				}else{ echo '<h4>'.esc_attr($title).'</h4>'; } ?>	        	
	        	<p><?php echo htmlspecialchars_decode($desc); ?></p>
	        </div>
	    <div class="clearfix"></div>    
		</div><!-- end section -->	
	</div>

<?php 
	return ob_get_clean();
}

// Services 2
add_shortcode('service2', 'service2_func');
function service2_func($atts, $content = null){
	extract(shortcode_atts(array(
		'icon' => '',
		'title' 	=> '',
		'desc' 	=> '',
		'link'  => '',
		'css'  => '',
	), $atts));

	$url = vc_build_link( $link );
	$img = wp_get_attachment_image_src($icon,'full');
    $img = $img[0];

	ob_start(); ?>

	<div class="our_products" <?php echo vc_shortcode_custom_css_class( $css ); ?> >
		<img class="image_left1" alt="" src="<?php echo esc_url($img); ?>">
		<?php if ( strlen( $link ) > 0 && strlen( $url['url'] ) > 0 ) {
			echo '<h3><a href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'.esc_attr($title).'</a></h3>';
		}else{echo '<h3>'.esc_attr($title).'</h3>'; } ?>        
	    <p><?php echo htmlspecialchars_decode($desc); ?></p>
	</div>

<?php 
	return ob_get_clean();
}

// Services 3
add_shortcode('service3', 'service3_func');
function service3_func($atts, $content = null){
	extract(shortcode_atts(array(
		'icon' => '',
		'title' 	=> '',
		'desc' 	=> '',
		'link'  => '',
		'css'   => ''
	), $atts));

	$url = vc_build_link( $link );
	$img = wp_get_attachment_image_src($icon,'full');
    $img = $img[0];    

	ob_start(); ?>
	<div <?php echo vc_shortcode_custom_css_class( $css ); ?> >
		<img class="image_left6" alt="" src="<?php echo esc_url($img); ?>">
	    <?php if ( strlen( $link ) > 0 && strlen( $url['url'] ) > 0 ) {
			echo '<h3><a href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'.esc_attr($title).'</a></h3>';
		}else{echo '<h3>'.esc_attr($title).'</h3>'; } ?> 
	    <p><?php echo htmlspecialchars_decode($desc); ?></p>	
    </div>
<?php 
	return ob_get_clean();
}

// Services 4
add_shortcode('service4', 'service4_func');
function service4_func($atts, $content = null){
	extract(shortcode_atts(array(
		'icon' => '',
		'title' 	=> '',
		'desc' 	=> '',
		'link'  => '',
		'css'   => ''
	), $atts));

	$url = vc_build_link( $link );
	$img = wp_get_attachment_image_src($icon,'full');
    $img = $img[0];

    $link1 = (!empty($link) ? '<strong><a href="'.esc_url($link).'">'.esc_attr($title).'</a></strong>' : '<strong>'.esc_attr($title).'</strong>' );

	ob_start(); ?>

	<div class="sideimg_list" <?php echo vc_shortcode_custom_css_class( $css ); ?> >
        <img alt="" src="<?php echo esc_url($img); ?>">
        <?php if ( strlen( $link ) > 0 && strlen( $url['url'] ) > 0 ) {
			echo '<strong><a href="' . esc_attr( $url['url'] ) . '" title="' . esc_attr( $url['title'] ) . '" target="' . ( strlen( $url['target'] ) > 0 ? esc_attr( $url['target'] ) : '_self' ) . '">'.esc_attr($title).'</a></strong>';
		}else{ echo '<strong>'.esc_attr($title).'</strong>'; } ?>
        <p><?php echo htmlspecialchars_decode($desc); ?></p>
    </div>

<?php 
	return ob_get_clean();
}

// Our Team
add_shortcode('team', 'team_func');
function team_func($atts, $content = null){
	extract(shortcode_atts(array(
		'photo'		=> 	'',
		'name'		=>	'',
		'desc'      =>	'',
		'job'		=>	'',
		'icon1'		=>	'',
		'icon2'		=>	'',
		'icon3'		=>	'',
		'icon4'		=>	'',
		'icon5'     =>	'',
		'url1'		=>	'',
		'url2'		=>	'',
		'url3'		=>	'',
		'url4'		=>	'',
		'url5'      =>	'',
	), $atts));

	$img = wp_get_attachment_image_src($photo,'full');
	$img = $img[0];

	$icon11 = (!empty($icon1) ? '<li><a href="'.esc_url($url1).'" target="_blank"><i class="fa fa-'.esc_attr($icon1).'"></i></a></li>' : '');
	$icon22 = (!empty($icon2) ? '<li><a href="'.esc_url($url2).'" target="_blank"><i class="fa fa-'.esc_attr($icon2).'"></i></a></li>' : '');
	$icon33 = (!empty($icon3) ? '<li><a href="'.esc_url($url3).'" target="_blank"><i class="fa fa-'.esc_attr($icon3).'"></i></a></li>' : '');
	$icon44 = (!empty($icon4) ? '<li><a href="'.esc_url($url4).'" target="_blank"><i class="fa fa-'.esc_attr($icon4).'"></i></a></li>' : '');
	$icon55 = (!empty($icon4) ? '<li><a href="'.esc_url($url5).'" target="_blank"><i class="fa fa-'.esc_attr($icon5).'"></i></a></li>' : '');

	ob_start(); ?>

    <div class="our_team_box">
        <div class="cont-area">
        	<img class="teammempic" alt="" src="<?php echo esc_url($img); ?>">
        	<p class="name_team"><strong><?php echo htmlspecialchars_decode($name); ?><i> <?php echo htmlspecialchars_decode($job); ?></i></strong></p>
        	<ul class="team_social">        		
                <?php echo htmlspecialchars_decode($icon11); ?>
                <?php echo htmlspecialchars_decode($icon22); ?>
                <?php echo htmlspecialchars_decode($icon33); ?>
                <?php echo htmlspecialchars_decode($icon44); ?>
                <?php echo htmlspecialchars_decode($icon55); ?>
        	</ul>
       </div>
       <?php if($desc) { ?><p><?php echo htmlspecialchars_decode($desc); ?></p><?php } ?>
	</div>

<?php
    return ob_get_clean();
}

//whats new
add_shortcode('whats_new', 'whats_new_func');
function whats_new_func($atts, $content = null){
	extract(shortcode_atts(array(
		'icon' => '',
		'title' 	=> '',
		'desc' 	=> '',
	), $atts));

	$img = wp_get_attachment_image_src($icon,'full');
    $img = $img[0];

	ob_start(); ?>

	<div class="whats_new">
		<img src="<?php echo esc_url($img); ?>" alt="" />
	    <h4><?php echo esc_attr($title); ?></h4>
        <p><?php echo htmlspecialchars_decode($desc); ?></p>
    <div class="clearfix"></div>     
    </div><!-- end section -->

<?php 
	return ob_get_clean();
}

//Support Box
add_shortcode('supportbox', 'supportbox_func');
function supportbox_func($atts, $content = null){
	extract(shortcode_atts(array(		
		'title' 	=> '',		
	), $atts));

	ob_start(); ?>

	<div class="our_support">
    	<h3><?php echo esc_attr($title); ?></h3>
    	<?php echo htmlspecialchars_decode($content); ?>    	    
    </div>

<?php 
	return ob_get_clean();
}

// Line
add_shortcode('head_line', 'head_line_func');
function head_line_func($atts, $content = null){
	extract(shortcode_atts(array(
		'headline' => 'headline1',		
	), $atts));

	$classline = '';
	if ($headline == 'headline4') {
		$classline = 'line4'; 
	}elseif ($headline == 'headline3') {
		$classline = 'line3';
	}elseif ($headline == 'headline2') {
		$classline = 'line2';
	}else{
		$classline = 'line1';
	}

	ob_start(); ?>

	<div class="clearfix divider_<?php echo esc_attr($classline); ?>"></div>

<?php 
	return ob_get_clean();
}

// Pricing Tables
add_shortcode('pricing','pricing_func');
function pricing_func($atts, $content = null){
    extract( shortcode_atts( array(
      'title'   	=> '',      
      'price'		=> '',
      'time'		=> '',     
      'details'		=> '',
      'btntext'		=> '',
      'btnlink'		=> '',     
   ), $atts ) );
    ob_start(); ?>

    <div class="hostplan">
    	<div class="title"><b><?php echo esc_attr( $price ); ?> <br /><i><?php echo esc_attr( $time ); ?></i></b> <strong><?php echo esc_attr( $title ); ?></strong></div>        
        <div class="details"><?php echo htmlspecialchars_decode( $details ); ?></div>     
        <p><a href="<?php echo esc_url( $btnlink ); ?>" class="black_button"><?php echo htmlspecialchars_decode( $btntext ); ?></a></p>
        <div class="shadow"></div>
    </div><!-- end host plan -->

<?php
    return ob_get_clean();
}

// Pricing Tables Compare
add_shortcode('compare_table','compare_table_func');
function compare_table_func($atts, $content = null){
    extract( shortcode_atts( array(
      'title'   	=> '',      
      'price'		=> '',
      'time'		=> '',           
      'btntext'		=> '',
      'btnlink'		=> '', 
      'col_width'   => '',    
   ), $atts ) );
    ob_start(); ?>

    <div class="hosting_page_plan" style="width: <?php echo esc_attr($col_width); ?>">
    	<div class="title"><?php echo esc_attr( $title ); ?></div>
        <div class="cont-list">
        	<?php echo wpb_js_remove_wpautop( $content ); ?>
        </div>
        <div class="ordernow"> <?php if($price != ''){ ?><span class="price"><?php echo esc_attr( $price ); ?><i><?php echo esc_attr( $time ); ?></i></span><?php } ?> <?php if($btnlink != ''){ ?> <a href="<?php echo esc_url( $btnlink ); ?>" class="ordernow_but"><?php echo htmlspecialchars_decode( $btntext ); ?></a> <?php } ?></div>
    </div>   
	
<?php
    return ob_get_clean();
}

// About Area
add_shortcode('aboutarea', 'aboutarea_func');
function aboutarea_func($atts, $content = null){
	extract(shortcode_atts(array(
		'image' => '',
		'title' 	=> '',
		'desc' 	=> '',
	), $atts));

	$img = wp_get_attachment_image_src($image,'full');
    $img = $img[0];

	ob_start(); ?>

	<div class="home_aboutarea">
    	<div class="left"><img src="<?php echo esc_url($img); ?>" alt="" /></div>
    	<div class="right">
	        <h2><?php echo esc_attr($title); ?></h2>
	        <p><?php echo htmlspecialchars_decode($desc); ?></p>
        </div>
        <div class="clearfix"></div>
    </div><!-- end section -->

<?php 
	return ob_get_clean();
}

// Banner ADs
add_shortcode('banner_ads', 'banner_ads_func');
function banner_ads_func($atts, $content = null){
	extract(shortcode_atts(array(
		'bgimage' => '',
		'title' 	=> '',		
		'btntext' => '',
		'btnlink' => '',
		'classbox' => ''
	), $atts));
	$img = wp_get_attachment_image_src($bgimage,'full');
    $img = $img[0];
	ob_start(); ?>

	<div class="<?php echo esc_attr($classbox); ?>" style="background-image: url(<?php echo esc_url($img); ?>);">
    	<?php echo wpb_js_remove_wpautop($content) ?>
        <?php if($btnlink != ''){ ?><a class="but" href="<?php echo esc_url($btnlink); ?>"><?php echo esc_attr($btntext); ?></a><?php } ?>
    </div>	

<?php 
	return ob_get_clean();
}

// Testimonial Slider
add_shortcode('testimonials','testimonials_func');
function testimonials_func($atts, $content = null){
	extract(shortcode_atts(array(
		'num'		=>		'',		
	), $atts));
	 ob_start(); ?>

	<div class="people_says">            
        <ul id="mycarousel" class="jcarousel-skin-tango"> 
        <?php
			$args = array(
				'post_type' => 'testimonial',
				'posts_per_page' => -1,
			);
			$testimonial = new WP_Query($args);
			if($testimonial->have_posts()) : while($testimonial->have_posts()) : $testimonial->the_post();
			$job = get_post_meta(get_the_ID(),'_cmb_test_job', true);

		?>           
            <li>
                <img src="<?php echo get_template_directory_uri(); ?>/images/quotes1.png" alt="" class="image_left7" />
                <?php the_content(); ?>
				<img src="<?php echo get_template_directory_uri(); ?>/images/quotes2.png" alt="" class="image_left11" />
                <div class="who_pic">
                    <div class="name"><strong>- <?php the_title(); ?></strong>
   					<i><?php if($job) echo htmlspecialchars_decode($job); ?></i></div>
                    <div class="picture"><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" alt=""></div>                    
                </div>
            </li>
        <?php endwhile; endif; ?>	
        </ul>        
    </div>
    
    <!-- jquery jcarousel -->
	<script type="text/javascript">
		jQuery(document).ready(function() {
			jQuery('#mycarousel').jcarousel();
		});	
	</script>

<?php
    return ob_get_clean();
}

// Testimonial Box
add_shortcode('testimonialsbox','testimonialsbox_func');
function testimonialsbox_func($atts, $content = null){
	extract(shortcode_atts(array(
		'name'		=>		'',	
		'photo'	 =>		'',
		'desc'  =>		'',
		'style' => 'default'
	), $atts));

	$img = wp_get_attachment_image_src($photo,'full');
    $img = $img[0];

	ob_start(); ?>

	<?php if($style == 'style2'){ ?>
		<div class="testimonials-5">        
	        <span><?php echo htmlspecialchars_decode($desc); ?>
	        <br /><strong>- <?php echo esc_attr($name); ?></strong></span>
	    </div><!-- end client says -->
	<?php }elseif ($style == 'style1') { ?>	
	    <div class="testimonials-4">        
	        <span></span>
	        <div class="content"><img src="<?php echo esc_url($img); ?>" alt="" /><p><?php echo htmlspecialchars_decode($desc); ?></p>
	        <strong>- <?php echo esc_attr($name); ?></strong></div>
	    </div>
	<?php }else{ ?>
	    <div class="testimonials-2">        
	        <span><?php echo htmlspecialchars_decode($desc); ?>
	        <br /><strong>- <?php echo esc_attr($name); ?></strong></span>
	    </div><!-- end client says -->    
	<?php } ?>

<?php
    return ob_get_clean();
}

// Call To Action
add_shortcode('cta1', 'cta_func');
function cta_func($atts, $content = null){
	extract(shortcode_atts(array(
		'title'				=> '',	
		'text'				=> '',
		'btntext' 			=> '',
		'btnlink' 			=> '',				
	), $atts));

	ob_start(); ?>

	<div class="punchline_text_box">
        <div class="left">
	        <strong><?php echo htmlspecialchars_decode($title); ?></strong>
	        <?php if($text){ ?><p><?php echo htmlspecialchars_decode($text); ?></p><?php } ?>        
        </div>
        <?php if($btnlink != ''){ ?><div class="right"><a href="<?php echo esc_url($btnlink); ?>" class="knowmore_but"><?php echo esc_attr($btntext); ?></a></div><?php } ?>
    </div>

<?php 

	return ob_get_clean();

}

// Pricing Tables 2
add_shortcode('pricing2','pricing2_func');
function pricing2_func($atts, $content = null){
    extract( shortcode_atts( array(
      'title'   	=> '',      
      'price'		=> '',
      'time'		=> '',  
      'subtime'     => '',     
      'btntext'		=> '',
      'btnlink'		=> '',
      'feature'		=> 'no',      
      'col_width'   => '',      
   ), $atts ) );

    $time1 = (!empty($time) ? '<i>'.esc_attr( $time ).'</i>' : '');
    $subtime = (!empty($subtime) ? '<small>'.esc_attr( $subtime ).'</small>' : '');

    ob_start(); ?>

    <div class="pricing-tables<?php if($feature == 'yes') echo '-helight'; ?>" <?php if($col_width != ''){ ?>style="width: <?php echo esc_attr($col_width); ?>"<?php } ?> > 
		<div class="title"><?php echo esc_attr( $title ); ?></div>
	    <div class="price"><?php echo esc_attr( $price ); ?> <?php echo htmlspecialchars_decode( $time1 ); ?> <?php echo htmlspecialchars_decode( $subtime ); ?></div>
	    <div class="cont-list">
	    	<?php echo htmlspecialchars_decode( $content ); ?>
	    </div>
	    <div class="ordernow"><a href="<?php echo esc_url( $btnlink ); ?>" class="btn-price <?php if($feature == 'yes'){ echo 'orange small colorchan'; }else{echo 'darkgray small align';} ?>"><?php echo esc_attr( $btntext ); ?></a></div>
	</div><!-- end section -->   

<?php

    return ob_get_clean();

}

// Button Group
add_shortcode('button_general','button_general_func');
function button_general_func($atts, $content = null){
    extract( shortcode_atts( array(      
      'style'        => 'but_ok_2',             
      'btntext'		=> '',
      'btnlink'		=> '', 
      'target'     => '_blank', 
   ), $atts ) );
    ob_start(); ?>
   
	<a href="<?php echo esc_url( $btnlink ); ?>" class="<?php echo esc_attr($style); ?>" target="<?php echo esc_attr($target); ?>"><?php echo esc_attr( $btntext ); ?></a>

<?php

    return ob_get_clean();

}

// Google Map
add_shortcode('ggmap','ggmap_func');
function ggmap_func($atts, $content = null){
    extract( shortcode_atts( array(
	  'idmap'		=> 'map-canvas',
	  'height'		=> '',	
      'lat'   		=> '',
      'long'	  	=> '',
      'zoom'		=> '',
      'address'		=> '',
	  'mapcolor'	=> '',
	  'icon'		=> '',
   ), $atts ) );   
   
	$icon1 = wp_get_attachment_image_src($icon,'full');
	$icon1 = $icon1[0];

	$idmap = (!empty($idmap) ? esc_attr($idmap) : 'map-canvas');   
   		
    ob_start(); ?>
    <div class="clearfix"></div>	 
    <div id="<?php echo esc_attr($idmap); ?>" class="contacts-map" style="<?php if($height) echo 'height: '.$height.'px;'; ?>"></div>

    <script type="text/javascript">
	
	(function($) {
    "use strict"
    $(document).ready(function(){
        
        var locations = [
			['<div class="infobox"><span><?php echo htmlspecialchars_decode($address);?><span></div>', <?php echo esc_attr($lat);?>, <?php echo esc_attr($long);?>, 2]
        ];
	
		var map = new google.maps.Map(document.getElementById('<?php echo htmlspecialchars_decode($idmap); ?>'), {
		    zoom: <?php echo esc_attr($zoom);?>,
			scrollwheel: false,
			navigationControl: true,
			mapTypeControl: false,
			scaleControl: false,
			draggable: true,
			styles: [ { "stylers": [ { "hue": "<?php echo esc_attr($mapcolor);?>" }, { "gamma": 1 } ] } ],
			center: new google.maps.LatLng(<?php echo esc_attr($lat);?>, <?php echo esc_attr($long);?>),
		  mapTypeId: google.maps.MapTypeId.ROADMAP
		});
	
		var infowindow = new google.maps.InfoWindow();
	
		var marker, i;
	
		for (i = 0; i < locations.length; i++) {  
	  
			marker = new google.maps.Marker({ 
			position: new google.maps.LatLng(locations[i][1], locations[i][2]), 
			map: map ,
			icon: '<?php echo esc_url($icon1);?>'
			});
		
		  google.maps.event.addListener(marker, 'click', (function(marker, i) {
			return function() {
			  infowindow.setContent(locations[i][0]);
			  infowindow.open(map, marker);
			}
		  })(marker, i));
		}
        
        });
    })(jQuery);   	
   	</script>
<?php

    return ob_get_clean();

}