<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8 no-js lt-ie9" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<?php global $theme_option; ?>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<meta name="SKYPE_TOOLBAR" content="SKYPE_TOOLBAR_PARSER_COMPATIBLE" />

	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		
	<!-- Favicons
	================================================== -->
	<?php if($theme_option['favicon']['url'] !=''){ ?>
        <link rel="icon" href="<?php echo esc_url($theme_option['favicon']['url']); ?>" type="image/x-icon">    
    <?php } ?>
	
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if($theme_option['version_type'] == 'boxed'){ echo '<div class="aoxhost-boxed-wrapper"><div class="aoxhost-boxed-container"><div class="aoxhost-boxed-inner">';} ?>

<div id="wrapper">

<!-- header begin -->
<header class="site-header">
    <div class="top_links">
        <div class="container">
            <div class="row">
                <div class="col-md-12">                                    
                    <?php if($theme_option['date-switch'] != false){ ?>
                        <div class="date_wrap">
                            <script type="text/javascript">
                                var mydate=new Date()
                                var year=mydate.getYear()
                                if (year < 1000)
                                year+=1900
                                var day=mydate.getDay()
                                var month=mydate.getMonth()
                                var daym=mydate.getDate()
                                if (daym<10)
                                daym="0"+daym
                                var montharray=new Array("January","February","March","April","May","June","July","August","September","October","November","December")
                                document.write("<b class='date'>"+montharray[month]+" "+daym+", "+year+"</b>")
                            </script>
                        </div>
                    <?php } ?>
                    <div class="top_contact_info">
                        <ul class="tci_list">
                            <?php if($theme_option['live_chat'] != ''){ ?>
                                <li class="top-info"><a href="<?php echo esc_attr($theme_option['live_chat']); ?>" target="_blank"><i class="fa fa-comment"></i> <?php _e('live chat', 'aoxhost') ?></a></li>
                            <?php } ?>
                            <?php if($theme_option['email'] != ''){ ?>
                                <li class="top-info"><a href="mailto:<?php echo esc_attr($theme_option['email']); ?>" target="_blank"><i class="fa fa-envelope"></i> <?php echo esc_attr($theme_option['email']); ?></a></li>
                            <?php } ?>
                            <?php if($theme_option['phone'] != ''){ ?>
                                <li class="top-info"><a href="tel:<?php echo esc_html($theme_option['phone']); ?>"><i class="fa fa-headphones"></i> <?php echo esc_html($theme_option['phone']); ?></a></li>
                            <?php } ?>
                            <?php if($theme_option['fax'] != ''){ ?>
                                <li class="top-info fax"><a href="#"><i class="fa fa-fax"></i> <?php echo esc_html($theme_option['fax']); ?></a></li>
                            <?php } ?>                                                   
                            <?php if($theme_option['facebook'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['facebook']); ?>"><i class="fa fa-facebook"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['twitter'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['twitter']); ?>"><i class="fa fa-twitter"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['github'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['github']); ?>"><i class="fa fa-github"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['dribbble'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['dribbble']); ?>"><i class="fa fa-dribbble"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['linkedin'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['linkedin']); ?>"><i class="fa fa-linkedin"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['vimeo'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['vimeo']); ?>"><i class="fa fa-vimeo-square"></i></a>
                                </li>
                            <?php } ?>                        
                            <?php if($theme_option['instagram'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['instagram']); ?>"><i class="fa fa-instagram"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['youtube'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['youtube']); ?>"><i class="fa fa-youtube"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['skype'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['skype']); ?>"><i class="fa fa-skype"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['google'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['google']); ?>"><i class="fa fa-google-plus"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['behance'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['behance']); ?>"><i class="fa fa-behance"></i></a>
                                </li>
                            <?php } ?>
                            <?php if($theme_option['rss'] != '') { ?>
                                <li class="top-social">
                                    <a target="_blank" href="<?php echo esc_url($theme_option['rss']); ?>"><i class="fa fa-rss"></i></a>
                                </li>
                            <?php } ?>   
                            <?php if($theme_option['country_text'] != ''){ ?>
                                <li class="country"><a href="#"><?php _e('Country:', 'aoxhost') ?></a></li>
                                <li class="country_select">
                                    <?php echo htmlspecialchars_decode($theme_option['country_text']); ?>                                                                         
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="top_section">
        <div class="container">
            <div id="logo"><a href="<?php echo esc_url( home_url('/') ); ?>" class="site_logo"><img src="<?php echo esc_url($theme_option['logo']['url']); ?>" alt=""></a></div><!-- end logo -->                            
            <!-- mainmenu begin -->
            <?php
                $primarymenu = array(
                    'theme_location'  => 'primary',
                    'menu'            => '',
                    'container'       => '',
                    'container_class' => '',
                    'container_id'    => '',
                    'menu_class'      => 'slimmenu',
                    'menu_id'         => 'mainmenu',
                    'echo'            => true,
                    'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                    'walker'          => new wp_bootstrap_navwalker(),
                    'before'          => '',
                    'after'           => '',
                    'link_before'     => '',
                    'link_after'      => '',
                    'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                    'depth'           => 0,
                );
                if ( has_nav_menu( 'primary' ) ) {
                    wp_nav_menu( $primarymenu );
                }
            ?>
            <!-- mainmenu close -->                                               
        </div> 
    </div>
    
</header>
<!-- header close -->