<?php

    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "theme_option";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name' => 'theme_option',
        'use_cdn' => TRUE,
        'display_name'     => $theme->get('Name'),
        'display_version'  => $theme->get('Version'),
        'page_title' => 'AoxHost Options',
        'update_notice' => FALSE,
        'admin_bar' => TRUE,
        'menu_type' => 'menu',
        'menu_title' => 'AoxHost Options',
        'allow_sub_menu' => TRUE,
        'page_parent_post_type' => 'your_post_type',
        'customizer' => FALSE,
        'dev_mode'   => false,
        'default_mark' => '*',
        'hints' => array(
            'icon_position' => 'right',
            'icon_color' => 'lightgray',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'light',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'duration' => '500',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => TRUE,
        'output_tag' => TRUE,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => TRUE,
        'page_permissions' => 'manage_options',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
    );    

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'aoxhost' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'aoxhost' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'aoxhost' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'aoxhost' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'aoxhost' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    // ACTUAL DECLARATION OF SECTIONS      
    Redux::setSection( $opt_name, array(
        'icon' => ' el-icon-picture',
        'title' => __('Logo & Favicon Settings', 'aoxhost'),
        'fields' => array(
            array(
                'id' => 'favicon',
                'type' => 'media',
                'url' => true,
                'title' => __('Custom Favicon', 'aoxhost'),
                'compiler' => 'true',
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'desc' => __('Upload your Favicon.', 'aoxhost'),
                'subtitle' => __('', 'aoxhost'),
                'default' => array('url' => get_template_directory_uri().'/images/favicon.png'),
            ),
            array(
                'id' => 'logo',
                'type' => 'media',
                'url' => true,
                'title' => __('Logo', 'aoxhost'),
                'compiler' => 'true',
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'desc' => __('logo.', 'aoxhost'),
                'subtitle' => __('', 'aoxhost'),
               'default' => array('url' => get_template_directory_uri().'/images/logo.png'),                     
            ),                                      
        )
    ) );

    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-qrcode',
        'title' => __('Header Settings', 'aoxhost'),
        'fields' => array(
            array(
                'id'       => 'date-switch',
                'type'     => 'switch', 
                'title'    => __('Date in top header Off?', 'aoxhost'),
                'subtitle' => __('Look, it\'s on!', 'aoxhost'),
                'default'  => true,
            ), 
            array(
                'id' => 'live_chat',
                'type' => 'text',
                'title' => __('Live Chat link', 'aoxhost'),
                'subtitle' => __('Input Live Chat link', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'default' => '#'
            ),  
            array(
                'id' => 'phone',
                'type' => 'text',
                'title' => __('Phone number', 'aoxhost'),
                'subtitle' => __('Input phone', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'default' => '1234-567-89000'
            ),  
            array(
                'id' => 'fax',
                'type' => 'text',
                'title' => __('Fax number', 'aoxhost'),
                'subtitle' => __('Input fax', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'default' => ''
            ), 
            array(
                'id' => 'email',
                'type' => 'text',
                'title' => __('Email address', 'aoxhost'),
                'subtitle' => __('Input Email', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'default' => 'name@company.com'
            ),  
            array(
                'id' => 'country_text',
                'type' => 'editor',
                'title' => __('Country Text', 'aoxhost'),
                'subtitle' => __('Country Text, leave a blank do not show on front-end.', 'aoxhost'),
                'default' => '',
            ),                       
        )
    ) );
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-twitter',
        'title' => __('Twitter Feed', 'aoxhost'),
        'fields' => array(
            array(
                'id'       => 'twitter-switch',
                'type'     => 'switch', 
                'title'    => __('Twitter Section Off?', 'aoxhost'),
                'subtitle' => __('Look, it\'s on!', 'aoxhost'),
                'default'  => true,
            ), 
            array(
                'id' => 'twitter_id',
                'type' => 'text',
                'title' => __('Add Twitter ID', 'aoxhost'),
                'subtitle' => __('How to get your twitter widget id ?: https://www.youtube.com/watch?v=Ypsib-Nx4VQ', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'default' => '428880392213381120'
            ),  
            array(
                'id' => 'twitter_bg',
                'type' => 'media',
                'title' => __('Twitter Background Image', 'aoxhost'),
                'subtitle' => __('Twitter Background Image', 'aoxhost'),
                'desc' => __('Background Image only Twitter', 'aoxhost'),
                'default' => array('url' => get_template_directory_uri().'/images/tweets-bg.png')
            ),                      
         )
    ) );
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-group',
        'title' => __('Socials Settings', 'aoxhost'),
        'fields' => array(
            array(
                'id' => 'facebook',
                'type' => 'text',
                'title' => __('Facebook Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => 'https://www.facebook.com/',
            ),
            array(
                'id' => 'twitter',
                'type' => 'text',
                'title' => __('Twitter Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => 'https://twitter.com/',
            ),                    
            array(
                'id' => 'google',
                'type' => 'text',
                'title' => __('Google+ Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => 'https://plus.google.com',
            ),                                    
            array(
                'id' => 'vimeo',
                'type' => 'text',
                'title' => __('Vimeo Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => '',
            ),
            array(
                'id' => 'youtube',
                'type' => 'text',
                'title' => __('Youtube Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => '',
            ),
            array(
                'id' => 'linkedin',
                'type' => 'text',
                'title' => __('Linkedin Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => 'https://www.linkedin.com/',
            ),
            array(
                'id' => 'dribbble',
                'type' => 'text',
                'title' => __('Dribbble Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => '',
            ),
            array(
                'id' => 'instagram',
                'type' => 'text',
                'title' => __('Instagram Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => ''
            ),
            array(
                'id' => 'github',
                'type' => 'text',
                'title' => __('Github Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => '#'
            ),
            array(
                'id' => 'skype',
                'type' => 'text',
                'title' => __('Skype Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => ''
            ), 
            array(
                'id' => 'behance',
                'type' => 'text',
                'title' => __('Behance Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => ''
            ), 
            array(
                'id' => 'rss',
                'type' => 'text',
                'title' => __('Rss Url', 'aoxhost'),
                //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.
                'default' => ''
            ), 
         )
    ) );    

    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-blogger',
        'title' => __('Blog Settings', 'aoxhost'),
        'fields' => array(
            array(
                'id' => 'blog_excerpt',
                'type' => 'text',
                'title' => __('Blog custom excerpt leng', 'aoxhost'),
                'subtitle' => __('Input Blog custom excerpt leng', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'default' => '30'
            ),                    
            array(
                'id' => 'the_blog_single',
                'type' => 'text',
                'title' => __('The Blog Single Title', 'aoxhost'),
                'subtitle' => __('Input blog single', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'default' => 'The Blog Single'
            ),                      
            array(
                'id' => 'comment',
                'type' => 'select',
                'title' => __('Show Comment?', 'aoxhost'),
                'subtitle' => __('Option Show Comment', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'options'  => array(
                    'yes' => 'Yes',
                    'no'  => 'No',
                ),
                'default' => 'no',
            ),
         )
    ) );                             

    Redux::setSection( $opt_name, array(
        'icon' => ' el-icon-credit-card',
        'title' => __('Footer Settings', 'aoxhost'),
        'fields' => array(                      
            array(
                'id' => 'footer_text',
                'type' => 'editor',
                'title' => __('Footer Text', 'aoxhost'),
                'subtitle' => __('Copyright Text', 'aoxhost'),
                'default' => '©2015 ALL RIGHT RESERVED. MADE BY OCEANTHEMES',
            ),                  
        )
    ) );
    Redux::setSection( $opt_name, array(
        'icon' => 'el-icon-website',
        'title' => __('Styling Options', 'aoxhost'),
        'fields' => array(
            array(
                'id' => 'version_type',
                'type' => 'select',
                'title' => __('Theme Version', 'aoxhost'),
                'subtitle' => __('Wide or Boxed', 'aoxhost'),
                'desc' => __('', 'aoxhost'),
                'options'  => array(
                    'wide' => 'Wide Version',
                    'boxed' => 'Boxed Version',
                ),
                'default' => 'wide',
            ),
            array(
                'id' => 'boxed_bg',
                'type' => 'media',
                'title' => __('Background Image', 'aoxhost'),
                'subtitle' => __('Background Image for Boxed Version', 'aoxhost'),
                'desc' => __('Background Image only for Boxed Version', 'aoxhost'),
                'default' => array('url' => get_template_directory_uri().'/images/bg-pattern/pat02.png')
            ), 
            array(
                'id' => 'page_title_bg',
                'type' => 'media',
                'title' => __('Page Title Background Image', 'aoxhost'),
                'subtitle' => __('Page Title Background Image', 'aoxhost'),
                'desc' => __('Background Image only Page Title', 'aoxhost'),
                'default' => array('url' => get_template_directory_uri().'/images/slider-bg.jpg')
            ),
            array(
                'id' => 'main-color',
                'type' => 'color',
                'title' => __('Theme Main Color', 'aoxhost'),
                'subtitle' => __('Pick the main color for the theme (default: #25aae2).', 'aoxhost'),
                'default' => '#25aae2',
                'validate' => 'color',
            ),  
            array(
                'id' => 'pricing-color',
                'type' => 'color',
                'title' => __('Theme Pricing Tables Color', 'aoxhost'),
                'subtitle' => __('Pick the pricing table color for the theme (default: #1397cf).', 'aoxhost'),
                'default' => '#1397cf',
                'validate' => 'color',
            ),  
            array(
                'id' => 'background_footer',
                'type' => 'color',
                'title' => __('Footer Background Color', 'aoxhost'),
                'subtitle' => __('Pick a background color for the footer (default: #2E2E2E).', 'aoxhost'),
                'default' => '',
                'validate' => 'color',
            ),
            array(
                'id' => 'sub_footer',
                'type' => 'color',
                'title' => __('Bottom Footer Background Color', 'aoxhost'),
                'subtitle' => __('Pick a  color for the footer (default: #272727).', 'aoxhost'),
                'default' => '#272727',
                'validate' => 'color',
            ),
            
            array(
                'id' => 'body-font2',
                'type' => 'typography',
                'output' => array('body'),
                'title' => __('Body Font', 'aoxhost'),
                'subtitle' => __('Specify the body font properties.', 'aoxhost'),
                'google' => true,
                'default' => array(
                    'color' => '',
                    'font-size' => '',
                    'line-height' => '',
                    'font-family' => '',
                    'font-weight' => ''
                ),
            ),
             array(
                'id' => 'custom-css',
                'type' => 'ace_editor',
                'title' => __('CSS Code', 'aoxhost'),
                'subtitle' => __('Paste your CSS code here.', 'aoxhost'),
                'mode' => 'css',
                'theme' => 'monokai',
                'desc' => 'Possible modes can be found at <a href="http://ace.c9.io" target="_blank">http://ace.c9.io/</a>.',
                'default' => "#header{\nmargin: 0 auto;\n}"
            ),
        )
    ) );

    /*
     * <--- END SECTIONS
     */