<?php
/**
 * The template for displaying the footer
 */
 global $theme_option; 
?>
    <?php if($theme_option['twitter-switch'] != false){ ?>
        <div class="twitter_feed">    
            <div class="container">        
                <img src="<?php echo get_template_directory_uri(); ?>/images/twitter-bird.png" alt="" class="image_left1" >                        
                <div class="tweets_block" id="latest-tweets">
                    <div id="tweets-list"></div>                
                </div>

                <script type="text/javascript">
                    (function($) {
                        "use strict";      
                        var config = {
                          "id": '<?php echo esc_attr($theme_option['twitter_id']); ?> ',
                          "domId": 'tweets-list',
                          "maxTweets": 1,
                          "enableLinks": true, 
                          "showUser": false,
                          "showTime": false,
                          "showRetweet": false,
                          "lang": 'en'
                        };
                        twitterFetcher.fetch(config);                                            
                    })(jQuery);
                </script>

            </div>    
        </div>
    <?php } ?>

	<!-- footer begin -->
    <footer>
        <div id="footer">
            <div class="container">
                <div class="row">
                    <?php get_sidebar('footer');?>
                </div>    
            </div>                                
            <div class="container">
                <div class="h_column_area">
                    <div class="row">
                        <div class="col-md-6 col-sm-6">
                            <?php if ( is_active_sidebar( 'footer-bottom-1' ) ) : ?>
                                <?php dynamic_sidebar( 'footer-bottom-1' ); ?>                                    
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6 col-sm-6">
                            <?php if ( is_active_sidebar( 'footer-bottom-2' ) ) : ?>
                                <?php dynamic_sidebar( 'footer-bottom-2' ); ?>                                    
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>                                
        </div>
        
        <div class="subfooter">
            <div class="container">
                <div class="row">
                    <div class="col-sm-6">
                        <?php echo wp_kses( $theme_option['footer_text'], wp_kses_allowed_html('post') ); ?>                                 
                    </div>
                    <?php
                        $footermenu = array(
                            'theme_location'  => 'second',
                            'menu'            => '',
                            'container'       => '',
                            'container_class' => '',
                            'container_id'    => '',
                            'menu_class'      => '',
                            'menu_id'         => '',
                            'echo'            => true,
                            'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                            'walker'          => new wp_bootstrap_navwalker(),
                            'before'          => '',
                            'after'           => '',
                            'link_before'     => '',
                            'link_after'      => '',
                            'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                            'depth'           => 0,
                        );
                        if ( has_nav_menu( 'second' ) ) {
                    ?>
                    <div class="col-sm-6">
                        <div class="menu-footer">
                            <?php wp_nav_menu( $footermenu ); ?>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer close -->
	
</div><!-- #wrapper -->
<?php if($theme_option['version_type'] == 'boxed'){ echo '</div></div></div>';} ?>	
<?php wp_footer(); ?>
</body>
</html>