<?php 
global $theme_option;
?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <div class="post-content">   
      <?php if ( has_post_thumbnail() ) { ?>
        <div class="post-image">
          <?php the_post_thumbnail(); ?>
        </div>
      <?php } ?>  
      <div class="date-box"><span class="day"><?php the_time('d'); ?></span> <span class="month"><?php the_time('M'); ?></span> </div>   
      <div class="post-text <?php if ( has_post_thumbnail() ) { echo 'post-text-no-image'; } ?>">        
            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>           
          <ul class="post-meta">
            <li><i class="fa fa-user"></i><?php the_author_posts_link(); ?></li> 
            <?php if(has_category()) { ?>
            <li><i class="fa fa-folder-open"></i><?php the_category(', '); ?></li> 
            <?php } ?>
            <li><i class="fa fa-comments"></i><a href="<?php comments_link(); ?>"><?php comments_number( __('0 comment', 'aoxhost'), __('1 comment', 'aoxhost'), __('% comments', 'aoxhost') ); ?></a></li>            
          </ul>
          <p><?php echo aoxhost_excerpt($theme_option['blog_excerpt']); ?></p>
      </div>
      <div class="clearfix"></div>
  </div>
</div>  