<?php
/*
Plugin Name: OT Testimonial
Plugin URI: http://oceanthemes.net/
Description: Declares a plugin that will create a custom post type displaying portfolio.
Version: 1.0
Author: OceanThemes Team
Author URI: http://oceanthemes.net/
License: GPLv2
*/




function ot_testimonials_type() {
	$testimoniallabels = array (	

		'name' => __('Testimonial','ot_testimonial'),

		'singular_name' => __('Testimonial','ot_testimonial'),

		'add_new' => __('Add testimonial','ot_testimonial'),

		'add_new_item' => __('Add new testimonial','ot_testimonial'),

		'edit_item' => __('Edit testimonial','ot_testimonial'),

		'new_item' => __('Add new testimonial','ot_testimonial'),

		'all_items' => __('All testimonial','ot_testimonial'),

		'view_item' => __('View testimonial','ot_testimonial'),

		'search_item' => __('Search testimonial','ot_testimonial'),

		'not_found' => __('No testimonial found..','ot_testimonial'),

		'not_found_in_trash' => __('No testimonial found in Trash.','ot_testimonial'),

		'menu_name' => 'Testimonial'

	

	);

	$args = array(

		'labels' => $testimoniallabels,
		'hierarchical' => true,
		'description' => 'Manages testimonial',
		'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
		'menu_icon' => plugins_url( 'images/testimonial.png', __FILE__ ),		
		'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
        'capability_type' => 'post',
		'supports' => array( 'title','editor','thumbnail','excerpt','comments','custom-fields'),
	);
		register_post_type ('testimonial',$args);
	}
add_action ('init','ot_testimonials_type');

function ot_testimonial_taxonomy () {
	$taxonomylabels = array(

	'name' => __('Category testimonial','ot_testimonial'),

	'singular_name' => __('Category testimonial','ot_testimonial'),

	'search_items' => __('Search Category testimonial','ot_testimonial'),

	'all_items' => __('All Category testimonial','ot_testimonial'),

	'edit_item' => __('Edit Category testimonial','ot_testimonial'),

	'add_new_item' => __('Add new Category testimonial','ot_testimonial'),

	'menu_name' => __('Category testimonial','ot_testimonial'),

	);

	$args = array(

	'labels' => $taxonomylabels,

	'hierarchical' => true,

);
	register_taxonomy('category_testimonial','testimonial',$args);
}
add_action ('init','ot_testimonial_taxonomy',0);

?>